/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.SectionMap;
import uk.co.demon.obelisk.xobj.SymbolMap;

public abstract class BinaryExpr
extends Expr {
    protected final Expr lhs;
    protected final Expr rhs;

    public final Expr getLhs() {
        return this.lhs;
    }

    public final Expr getRhs() {
        return this.rhs;
    }

    public final boolean isAbsolute() {
        return this.lhs.isAbsolute() && this.rhs.isAbsolute();
    }

    public final boolean isExternal(Section section) {
        return this.lhs.isExternal(section) || this.rhs.isExternal(section);
    }

    public abstract long resolve(SectionMap var1, SymbolMap var2);

    protected BinaryExpr(Expr lhs, Expr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public static final class Add
    extends BinaryExpr {
        public Add(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) + this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<add>" + this.lhs + this.rhs + "</add>";
        }
    }

    public static final class And
    extends BinaryExpr {
        public And(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) & this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<and>" + this.lhs + this.rhs + "</and>";
        }
    }

    public static final class Div
    extends BinaryExpr {
        public Div(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) / this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<div>" + this.lhs + this.rhs + "</div>";
        }
    }

    public static final class Eq
    extends BinaryExpr {
        public Eq(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) == this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<eq>" + this.lhs + this.rhs + "</eq>";
        }
    }

    public static final class Ge
    extends BinaryExpr {
        public Ge(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) >= this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<ge>" + this.lhs + this.rhs + "</ge>";
        }
    }

    public static final class Gt
    extends BinaryExpr {
        public Gt(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) > this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<gt>" + this.lhs + this.rhs + "</gt>";
        }
    }

    public static final class LAnd
    extends BinaryExpr {
        public LAnd(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) != 0L && this.rhs.resolve(sections, symbols) != 0L) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<land>" + this.lhs + this.rhs + "</land>";
        }
    }

    public static final class LOr
    extends BinaryExpr {
        public LOr(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) != 0L || this.rhs.resolve(sections, symbols) != 0L) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<lor>" + this.lhs + this.rhs + "</lor>";
        }
    }

    public static final class Le
    extends BinaryExpr {
        public Le(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) <= this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<le>" + this.lhs + this.rhs + "</le>";
        }
    }

    public static final class Lt
    extends BinaryExpr {
        public Lt(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) < this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<lt>" + this.lhs + this.rhs + "</lt>";
        }
    }

    public static class Mod
    extends BinaryExpr {
        public Mod(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) % this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<mod>" + this.lhs + this.rhs + "</mod>";
        }
    }

    public static final class Mul
    extends BinaryExpr {
        public Mul(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) * this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<mul>" + this.lhs + this.rhs + "</mul>";
        }
    }

    public static final class Ne
    extends BinaryExpr {
        public Ne(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            if (this.lhs.resolve(sections, symbols) != this.rhs.resolve(sections, symbols)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "<ne>" + this.lhs + this.rhs + "</ne>";
        }
    }

    public static final class Or
    extends BinaryExpr {
        public Or(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) | this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<or>" + this.lhs + this.rhs + "</or>";
        }
    }

    public static class Shl
    extends BinaryExpr {
        public Shl(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) << (int)this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<shl>" + this.lhs + this.rhs + "</shl>";
        }
    }

    public static class Shr
    extends BinaryExpr {
        public Shr(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) >> (int)this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<shr>" + this.lhs + this.rhs + "</shr>";
        }
    }

    public static final class Sub
    extends BinaryExpr {
        public Sub(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) - this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<sub>" + this.lhs + this.rhs + "</sub>";
        }
    }

    public static final class Xor
    extends BinaryExpr {
        public Xor(Expr lhs, Expr rhs) {
            super(lhs, rhs);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.lhs.resolve(sections, symbols) ^ this.rhs.resolve(sections, symbols);
        }

        public String toString() {
            return "<xor>" + this.lhs + this.rhs + "</xor>";
        }
    }
}

